/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.bind;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProject;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.ui.internal.bind.AbstractModelObject;

public class ProjectBindModel
extends AbstractModelObject {
    public static final String PROPERTY_PROJECT_ECLIPSE_NAME = "eclipseName";
    public static final String PROPERTY_PROJECT_SONAR_FULLNAME = "sonarFullName";
    private final IProject project;
    private String moduleKey;
    private String serverId;
    private IServer server;
    private boolean autoBindFailed;

    public ProjectBindModel(IProject project) {
        this.project = project;
        SonarLintProject sonarProject = SonarLintProject.getInstance((IResource)project);
        this.moduleKey = sonarProject.getModuleKey();
        this.serverId = sonarProject.getServerId();
        this.server = ServersManager.getInstance().getServer(this.serverId);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getEclipseName() {
        return this.project.getName();
    }

    public String getSonarFullName() {
        if (StringUtils.isBlank((String)this.moduleKey)) {
            if (this.autoBindFailed) {
                return "<Auto-bind failed. Type here to start searching for a remote SonarQube project...>";
            }
            return "<Type here to start searching for a remote SonarQube project...>";
        }
        if (this.server == null) {
            return "<Bound to an unknown server: '" + this.serverId + "'>";
        }
        return "'" + this.moduleKey + "' on server '" + this.server.getName() + "'";
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public void associate(String serverId, String sonarProjectName, String key) {
        String oldValue = this.getSonarFullName();
        this.moduleKey = key;
        this.serverId = serverId;
        this.server = ServersManager.getInstance().getServer(this.serverId);
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getSonarFullName());
    }

    public void unassociate() {
        String oldValue = this.getSonarFullName();
        this.moduleKey = null;
        this.serverId = null;
        this.server = null;
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getSonarFullName());
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setAutoBindFailed(boolean autoBindFailed) {
        String oldValue = this.getSonarFullName();
        this.autoBindFailed = autoBindFailed;
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getSonarFullName());
    }
}

